// Populate the sidebar
//
// This is a script, and not included directly in the page, to control the total size of the book.
// The TOC contains an entry for each page, so if each page includes a copy of the TOC,
// the total size of the page becomes O(n**2).
class MDBookSidebarScrollbox extends HTMLElement {
    constructor() {
        super();
    }
    connectedCallback() {
        this.innerHTML = '<ol class="chapter"><li class="chapter-item expanded "><a href="Lecture_Introduction/main.html"><strong aria-hidden="true">1.</strong> Introduction</a></li><li class="chapter-item expanded "><a href="Lecture_Introduction_to_UNIX/main.html"><strong aria-hidden="true">2.</strong> Introduction to UNIX</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="Lecture_Introduction_to_UNIX/Unix_and_Linux_operating_systems.html"><strong aria-hidden="true">2.1.</strong> Unix and Linux operating systems</a></li><li class="chapter-item expanded "><a href="Lecture_Introduction_to_UNIX/kernel_and_system_calls.html"><strong aria-hidden="true">2.2.</strong> Kernel and system calls</a></li><li class="chapter-item expanded "><a href="Lecture_Introduction_to_UNIX/Shell_and_basic_Unix_commands_BASIC.html"><strong aria-hidden="true">2.3.</strong> Bash (CHECK THIS VERSION and below)</a></li><li class="chapter-item expanded "><a href="Lecture_Introduction_to_UNIX/Shell_and_basic_Unix_commands.html"><strong aria-hidden="true">2.4.</strong> Bash (big bucket: to be split)</a></li><li class="chapter-item expanded "><a href="Lecture_Introduction_to_UNIX/Bash_Job_Control_System_aka_Multitasking.html"><strong aria-hidden="true">2.5.</strong> Bash Multitasking</a></li></ol></li><li class="chapter-item expanded "><a href="Lecture_Practical_UNIX/main.html"><strong aria-hidden="true">3.</strong> Practical UNIX</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="Lecture_Practical_UNIX/vi_basic.html"><strong aria-hidden="true">3.1.</strong> vi (basic)</a></li><li class="chapter-item expanded "><a href="Lecture_Practical_UNIX/vi_advanced.html"><strong aria-hidden="true">3.2.</strong> vi (advanced)</a></li><li class="chapter-item expanded "><a href="Lecture_Practical_UNIX/compilers_BASIC.html"><strong aria-hidden="true">3.3.</strong> compilers, gcc (examples)</a></li></ol></li><li class="chapter-item expanded "><a href="Lecture_the_C_programming_language_basics/main.html"><strong aria-hidden="true">4.</strong> The C programming language: basics</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="Lecture_the_C_programming_language_basics/C_BASIC.html"><strong aria-hidden="true">4.1.</strong> First example code: functions, if, for, printf</a></li><li class="chapter-item expanded "><a href="Lecture_the_C_programming_language_basics/C_arrays_BASIC.html"><strong aria-hidden="true">4.2.</strong> Arrays</a></li><li class="chapter-item expanded "><a href="Lecture_the_C_programming_language_basics/C_pointers_BASIC.html"><strong aria-hidden="true">4.3.</strong> Pointers</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="Lecture_the_C_programming_language_basics/C_strings_and_memory_layout.html"><strong aria-hidden="true">4.3.1.</strong> Pointers, arrays and strings a bit more in depth</a></li><li class="chapter-item expanded "><a href="Lecture_the_C_programming_language_basics/C_pointers_and_arrays.html"><strong aria-hidden="true">4.3.2.</strong> Arrays and pointers</a></li><li class="chapter-item expanded "><a href="Lecture_the_C_programming_language_basics/C_reference_vs_value.html"><strong aria-hidden="true">4.3.3.</strong> Call by reference and by value</a></li></ol></li></ol></li><li class="chapter-item expanded "><a href="Lecture_the_Fortran_programming_language/main.html"><strong aria-hidden="true">5.</strong> The Fortran programming language: basics</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="Lecture_the_Fortran_programming_language/Fortran_BASIC.html"><strong aria-hidden="true">5.1.</strong> First example code: functions, if, for, printf</a></li><li class="chapter-item expanded "><a href="Lecture_the_Fortran_programming_language/Fortran_arrays_BASIC.html"><strong aria-hidden="true">5.2.</strong> Arrays</a></li><li class="chapter-item expanded "><a href="Lecture_the_Fortran_programming_language/Fortran_allocatable_BASIC.html"><strong aria-hidden="true">5.3.</strong> Allocatable</a></li></ol></li><li class="chapter-item expanded "><a href="Lecture_Exercises_on_C_FORTRAN/main.html"><strong aria-hidden="true">6.</strong> Exercises basics</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="Lecture_Exercises_on_C_FORTRAN/Exercises_BASIC.html"><strong aria-hidden="true">6.1.</strong> BASIC</a></li><li class="chapter-item expanded "><a href="Lecture_Exercises_on_C_FORTRAN/Exercises_arrays_pointers.html"><strong aria-hidden="true">6.2.</strong> Arrays and pointers</a></li></ol></li><li class="chapter-item expanded "><a href="Lecture_the_C_programming_language_lib_struc_io/main.html"><strong aria-hidden="true">7.</strong> The C programming language: libraries, strucutres, I/O</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="Lecture_the_C_programming_language_lib_struc_io/types.html"><strong aria-hidden="true">7.1.</strong> structs I lost track with this, check the example below (MS)</a></li><li class="chapter-item expanded "><a href="Lecture_the_C_programming_language_lib_struc_io/example.html"><strong aria-hidden="true">7.2.</strong> structs, FILE and buffered I/O, an example</a></li></ol></li><li class="chapter-item expanded "><a href="Lecture_the_Fortran_programming_language_types_io/example.html"><strong aria-hidden="true">8.</strong> The Fortran programming language: types, I/O</a></li><li class="chapter-item expanded "><a href="Lecture_Gaussian_quadrature/main.html"><strong aria-hidden="true">9.</strong> Gaussian quadrature</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="Lecture_Gaussian_quadrature/exercise.html"><strong aria-hidden="true">9.1.</strong> Exercise</a></li></ol></li><li class="chapter-item expanded "><a href="Lecture_Anatomy_of_CPU/main.html"><strong aria-hidden="true">10.</strong> Anatomy of a CPU</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="Lecture_Anatomy_of_CPU/x86_history.html"><strong aria-hidden="true">10.1.</strong> Short history of x86 CPUs</a></li><li class="chapter-item expanded "><a href="Lecture_Anatomy_of_CPU/x86_assembly.html"><strong aria-hidden="true">10.2.</strong> x86 assembly language basics</a></li></ol></li><li class="chapter-item expanded "><a href="Lecture_Debuggers_and_typical_problems_that_require_them/main.html"><strong aria-hidden="true">11.</strong> Debuggers and typical problems that require them</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="Lecture_Debuggers_and_typical_problems_that_require_them/gdb.html"><strong aria-hidden="true">11.1.</strong> gdb</a></li></ol></li><li class="chapter-item expanded "><a href="Lecture_LU_decomposition/main.html"><strong aria-hidden="true">12.</strong> LU decomposition</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="Lecture_LU_decomposition/backward_example.html"><strong aria-hidden="true">12.1.</strong> Example: back substitution</a></li><li class="chapter-item expanded "><a href="Lecture_LU_decomposition/forward_example.html"><strong aria-hidden="true">12.2.</strong> Example: forward substitution</a></li><li class="chapter-item expanded "><a href="Lecture_LU_decomposition/example_LU.html"><strong aria-hidden="true">12.3.</strong> Example: LU decomposition</a></li><li class="chapter-item expanded "><a href="Lecture_LU_decomposition/spectral_density.html"><strong aria-hidden="true">12.4.</strong> Extraction of spectral densities from lattice correlators</a></li></ol></li><li class="chapter-item expanded "><a href="Lecture_Lapack/main.html"><strong aria-hidden="true">13.</strong> LAPACK</a></li><li class="chapter-item expanded "><a href="Lecture_Performances_in_basic_linear_algebra/main.html"><strong aria-hidden="true">14.</strong> Performances in basic linear algebra</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="Lecture_Performances_in_basic_linear_algebra/effect_of_optimisation.html"><strong aria-hidden="true">14.1.</strong> effect of optimisation</a></li></ol></li><li class="chapter-item expanded "><a href="Lecture_FFT/main.html"><strong aria-hidden="true">15.</strong> Fast Fourier Tansform (FFT)</a></li><li class="chapter-item expanded "><a href="Lecture_MPI_OpenMP/main.html"><strong aria-hidden="true">16.</strong> Message Passing Interface (MPI)</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="Lecture_MPI_OpenMP/MPI.html"><strong aria-hidden="true">16.1.</strong> Introduction to MPI</a></li><li class="chapter-item expanded "><a href="Lecture_MPI_OpenMP/MPI_SndRcv.html"><strong aria-hidden="true">16.2.</strong> MPI send and receive</a></li><li class="chapter-item expanded "><a href="Lecture_MPI_OpenMP/MPI_other_functions.html"><strong aria-hidden="true">16.3.</strong> MPI: other functions</a></li><li class="chapter-item expanded "><a href="Lecture_MPI_OpenMP/MPI_Cartesian.html"><strong aria-hidden="true">16.4.</strong> MPI: Cartesian topology</a></li><li class="chapter-item expanded "><a href="Lecture_MPI_OpenMP/OpenMP.html"><strong aria-hidden="true">16.5.</strong> Introduction to OpenMP</a></li><li class="chapter-item expanded "><a href="Lecture_MPI_OpenMP/performances_strong_weak_scaling.html"><strong aria-hidden="true">16.6.</strong> Performances in parallel computing</a></li></ol></li><li class="chapter-item expanded "><a href="Lecture_CUDA/main.html"><strong aria-hidden="true">17.</strong> CUDA</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="Lecture_CUDA/CUDA.html"><strong aria-hidden="true">17.1.</strong> Example</a></li><li class="chapter-item expanded "><a href="Lecture_CUDA/query_GPU_prop.html"><strong aria-hidden="true">17.2.</strong> Query device properties</a></li><li class="chapter-item expanded "><a href="Lecture_CUDA/scaling.html"><strong aria-hidden="true">17.3.</strong> Performance analysis</a></li></ol></li><li class="chapter-item expanded "><a href="Lecture_best_practice/main.html"><strong aria-hidden="true">18.</strong> Best Programming Practices</a></li><li class="chapter-item expanded "><a href="Lecture_roundoff/main.html"><strong aria-hidden="true">19.</strong> Round-off errors and Machine precision</a></li><li class="chapter-item expanded "><a href="Lecture_Git_for_version_control/main.html"><strong aria-hidden="true">20.</strong> Git and version control system</a></li><li><ol class="section"><li class="chapter-item expanded "><a href="Lecture_Git_for_version_control/basics.html"><strong aria-hidden="true">20.1.</strong> Basic commands</a></li><li class="chapter-item expanded "><a href="Lecture_Git_for_version_control/branching.html"><strong aria-hidden="true">20.2.</strong> Branching</a></li><li class="chapter-item expanded "><a href="Lecture_Git_for_version_control/remote.html"><strong aria-hidden="true">20.3.</strong> Remote and Collaboration</a></li></ol></li></ol>';
        // Set the current, active page, and reveal it if it's hidden
        let current_page = document.location.href.toString().split("#")[0].split("?")[0];
        if (current_page.endsWith("/")) {
            current_page += "index.html";
        }
        var links = Array.prototype.slice.call(this.querySelectorAll("a"));
        var l = links.length;
        for (var i = 0; i < l; ++i) {
            var link = links[i];
            var href = link.getAttribute("href");
            if (href && !href.startsWith("#") && !/^(?:[a-z+]+:)?\/\//.test(href)) {
                link.href = path_to_root + href;
            }
            // The "index" page is supposed to alias the first chapter in the book.
            if (link.href === current_page || (i === 0 && path_to_root === "" && current_page.endsWith("/index.html"))) {
                link.classList.add("active");
                var parent = link.parentElement;
                if (parent && parent.classList.contains("chapter-item")) {
                    parent.classList.add("expanded");
                }
                while (parent) {
                    if (parent.tagName === "LI" && parent.previousElementSibling) {
                        if (parent.previousElementSibling.classList.contains("chapter-item")) {
                            parent.previousElementSibling.classList.add("expanded");
                        }
                    }
                    parent = parent.parentElement;
                }
            }
        }
        // Track and set sidebar scroll position
        this.addEventListener('click', function(e) {
            if (e.target.tagName === 'A') {
                sessionStorage.setItem('sidebar-scroll', this.scrollTop);
            }
        }, { passive: true });
        var sidebarScrollTop = sessionStorage.getItem('sidebar-scroll');
        sessionStorage.removeItem('sidebar-scroll');
        if (sidebarScrollTop) {
            // preserve sidebar scroll position when navigating via links within sidebar
            this.scrollTop = sidebarScrollTop;
        } else {
            // scroll sidebar to current active section when navigating via "next/previous chapter" buttons
            var activeSection = document.querySelector('#sidebar .active');
            if (activeSection) {
                activeSection.scrollIntoView({ block: 'center' });
            }
        }
        // Toggle buttons
        var sidebarAnchorToggles = document.querySelectorAll('#sidebar a.toggle');
        function toggleSection(ev) {
            ev.currentTarget.parentElement.classList.toggle('expanded');
        }
        Array.from(sidebarAnchorToggles).forEach(function (el) {
            el.addEventListener('click', toggleSection);
        });
    }
}
window.customElements.define("mdbook-sidebar-scrollbox", MDBookSidebarScrollbox);
